# R/utils.R

#' Internal null-coalescing operator
#'
#' Returns `a` if it is not NULL; otherwise returns `b`.
#'
#' This version is hardened for CRAN:
#'   - avoids partial matching issues,
#'   - protects against length > 1 inputs,
#'   - protects against missing arguments,
#'   - keeps behaviour deterministic.
#'
#' @keywords internal
#' @noRd
`%||%` <- function(a, b) {
  # If `a` is missing, return b
  if (missing(a)) return(b)
  
  # If `a` is explicitly NULL → return b
  if (is.null(a)) return(b)
  
  # If `a` is length 0 (weird but possible)
  if (length(a) == 0L) return(b)
  
  # Else return a unchanged
  a
}