% Generated by roxygen2: do not edit by hand
% Please edit documentation in R/FuzzyMF.R
\name{evalmf}
\alias{evalmf}
\title{Evaluate fuzzy membership function}
\usage{
evalmf(...)
}
\arguments{
\item{...}{For singleton fuzzification: x, mf.type, mf.params; x, mf. \cr Four additional parameters need to be used for non-singleton fuzzification: fuzzification.method, fuzzification.params, firing.method and input.range.
See details below for more information.}
}
\value{
Membership grade(s)
}
\description{
To obtain the corresponding membership grade(s) for given crsip input(s) x
}
\details{
\itemize{
\item x - the crisp input(s) on the universe of discourse for corresponding antecedent membership function \cr
\item mf.type - The type of fuzzy membership function\cr
\item mf.params - The parameters for the given type of membership function\cr
\item mf - the membership function generated by \code{\link{genmf}}
\item fuzzification.method, fuzzification.params, firing.method and input.range - see \code{\link{addvar}}
}

Usage:
\enumerate{
\item evalmf(x, mf.type, mf.params)
\item evalmf(x, mf)
\item evalmf(x, mf.type, mf.params, fuzzification.method, fuzzification.params, firing.method, input.range)
\item evalmf(x, mf, fuzzification.method, fuzzification.params, firing.method, input.range )
}
}
\examples{
evalmf(5, mf.type=gbellmf, mf.params=c(1,2,3))
evalmf(1:10, mf.type=gbellmf, mf.params=c(1,2,3))
evalmf(1:10, mf.type=gbellmf, mf.params=c(1,2,3), fuzzification.method='gauss',
         fuzzification.params=1, firing.method='tnorm.min.max', input.range=c(0,10))

mf <- genmf('gbellmf', c(1,2,3))
evalmf(5, mf)
evalmf(1:10, mf)
evalmf(1:10, mf, fuzzification.method='gauss', fuzzification.params=1,
         firing.method='tnorm.min.max', input.range=c(0,10))
}
\author{
Chao Chen
}
