test_that("t norm works", {
  expect_equal(get_tnorm("Einstein Product"), "einstein_product_tnorm")
  expect_equal(get_tnorm("Min"), "min_tnorm")
  expect_equal(get_tnorm("Hamacher Product"), "hamacher_product_tnorm")
  expect_equal(get_tnorm("Algebraic Product"), "algebraic_product_tnorm")
  expect_equal(get_tnorm("Bounded Difference"), "bounded_difference_tnorm")
  expect_equal(get_tnorm("Drastic Product"), "drastic_product_tnorm")
  expect_equal(get_tnorm("Parameterized mean intersection operator"), "parameterized_mean_intersection_operator_tnorm")
  expect_equal(get_tnorm("Dubois-intersection operator"), "dubois_intersection_operator_tnorm")
  expect_equal(get_tnorm("Hamacher-intersection operator"), "hamacher_intersection_operator_tnorm")
  expect_equal(get_tnorm("Yager-intersection operator"), "yager_intersection_operator_tnorm")

  expect_equal(min_tnorm(1,5), 1)
  expect_equal(hamacher_product_tnorm(4,2), -4)
  expect_equal(algebraic_product_tnorm(1,3), 3)
  expect_equal(einstein_product_tnorm(2,4), 2)
  expect_equal(bounded_difference_tnorm(3,5), 8)
  expect_equal(drastic_product_tnorm(1,4), 0)
  expect_equal(drastic_product_tnorm(1,0), 0)
  expect_equal(parameterized_mean_intersection_operator_tnorm(1,4, gammaTnormMean = 0), 2.5)
  expect_equal(dubois_intersection_operator_tnorm(1,4, algaTnorm = 0), 1)
  expect_equal(hamacher_intersection_operator_tnorm(1,3, gammaTnorm = 0), 3)
  expect_equal(yager_intersection_operator_tnorm(1,4,piTnorm = 0), 0)
})
