% Generated by roxygen2: do not edit by hand
% Please edit documentation in R/plotRawdata.R
\name{plotRawdata}
\alias{plotRawdata}
\title{Visualization of the sequence (genotypes) data}
\usage{
plotRawdata(location, X, color = NULL, pch = 16, cex = 0.9)
}
\arguments{
\item{location}{a numeric vector defining the sampling sites of the sequence data.}

\item{X}{a matrix specifying the sequence data, with the number of rows equal to the number of samples.}

\item{color}{A specification for the default plotting color. See graphical parameters (\code{\link{par}}) for more details.}

\item{pch}{Either an integer specifying a symbol or a single character to be used as the default in plotting points. See graphical parameters (\code{\link{par}}) for more details.}

\item{cex}{A numerical value giving the amount by which plotting text and symbols should be magnified relative to the default. See graphical parameters (\code{\link{par}}) for more details.}
}
\value{
show the sequence data.
}
\description{
Display the sequence data, such as the data generated by simX. The horizontal axis represents the sampling sites, and the vertical axis represents the sequence values containing only 0, 1 and 2.
}
\examples{
library(FunctanSNP)
n <- 20
m <- 50
simdata <- simX(n, m, seed = 1, d.ratio = 0)
X <- simdata$X
location <- simdata$location
plotRawdata(location, X = X[1:2, ])

}
\seealso{
See Also as \code{\link{simX}}, \code{\link{SNPgvf}}.
}
