% Generated by roxygen2: do not edit by hand
% Please edit documentation in R/alpha_workflow.R
\name{alpha_div_contrib}
\alias{alpha_div_contrib}
\title{Main function for computing contributional \strong{alpha} diversity}
\usage{
alpha_div_contrib(
  metrics,
  func_tab = NULL,
  abun_tab = NULL,
  contrib_tab = NULL,
  in_tree = NULL,
  ncores = 1,
  replace_NA = FALSE,
  custom_metric_functions = NULL,
  samp_colname = "sample",
  func_colname = "function.",
  taxon_colname = "taxon",
  abun_colname = "taxon_abun"
)
}
\arguments{
\item{metrics}{alpha diversity metrics to compute. Must either be names of functions in \code{FuncDiv_alpha_metrics}, or alternatively in \code{custom_metric_functions}, if specified.}

\item{func_tab}{data.frame object containing function copy numbers, with rows as functions and columns as taxa. Required if \code{abun_tab} is specified, and is mutually exclusive with \code{contrib_tab}.}

\item{abun_tab}{data.frame object containing taxonomic abundances across samples, with rows as taxa and columns as samples. Required if \code{func_tab} is specified, and is mutually exclusive with \code{contrib_tab}.}

\item{contrib_tab}{data.frame object containing combined taxa abundances and function copy numbers across taxa. Must contain columns corresponding to the sample ids, function ids, taxa ids, and taxa
abundances within samples. These column names are specified by the \code{samp_colname}, \code{func_colname}, \code{taxon_colname}, and \code{abun_colname}, respectively. Mutually exclusive with \code{abun_tab} and \code{func_tab}.}

\item{in_tree}{phylo object to use if \code{faiths_pd} is specified.}

\item{ncores}{integer indicating number of cores to use for parallelizable steps.}

\item{replace_NA}{Boolean vector of length one, indicating whether all NA's in the output of all metrics should be converted to 0's. Note that this done automatically done for \code{richness} either way.}

\item{custom_metric_functions}{List object containing custom alpha diversity metric functions. This overrides \code{FuncDiv_alpha_metrics} when specified. The list element names must correspond to at
least the names indicated by the \code{metrics} parameter.}

\item{samp_colname}{sample id column name of \code{contrib_tab} input data.frame.}

\item{func_colname}{function id column name of \code{contrib_tab} input data.frame.}

\item{taxon_colname}{taxon id column name of \code{contrib_tab} input data.frame.}

\item{abun_colname}{taxonomic abundance (within each sample) column name of \code{contrib_tab} input data.frame.}
}
\value{
a list, containing one dataframe for each specified alpha diversity metric.
In each dataframe, rows are functions and samples are columns.
}
\description{
Based on joint taxa-function input data (i.e., contributional data), a dataframe
will be returned for each specified metric, which will contain the metric values for all function and sample combinations.
}
\details{
Input data can be either a separate function copy number and taxonomic abundance table, or a joint contributional table.
By default, specified metrics must be one of \code{names(FuncDiv_alpha_metrics)}. However, custom alpha diversity metric functions
can be specified with the \code{custom_metric_functions} parameter.

Note that the taxonomic abundances can be relative abundance, read counts, or transformed in another way. However, note that some default metrics
are only compatible with count data (see \code{?FuncDiv_alpha_metrics}).
}
\examples{
# First, simulate some (non-realistic) data.
set.seed(123)
test_tree <- ape::rtree(100)
test_abun <- data.frame(matrix(rnorm(500), nrow = 100, ncol = 5))
rownames(test_abun) <- test_tree$tip.label
colnames(test_abun) <- c("sample1", "sample2", "sample3", "sample4", "sample5")
test_abun[test_abun < 0] <- 0
test_func <- data.frame(matrix(sample(c(0L, 1L), 200, replace = TRUE),
                               nrow = 2, ncol = 100))
colnames(test_func) <- test_tree$tip.label
rownames(test_func) <- c("func1", "func2")

# Compute alpha diversity, based on (observed) richness, Faith's phylogenetic
# diversity, and the Gini-Simpson Index.
contrib_alpha <- alpha_div_contrib(metrics = c("richness",  "faiths_pd", "gini_simpson_index"),
                                   func_tab = test_func,
                                   abun_tab = test_abun,
                                   in_tree = test_tree,
                                   ncores = 1)

# Print out computed Gini-Simpson Index values.
contrib_alpha$gini_simpson_index

}
