% Generated by roxygen2: do not edit by hand
% Please edit documentation in R/MLCSW.R
\name{MLCSW}
\alias{MLCSW}
\title{Multinomial logistic calibration estimator under single frame approach with auxiliary information from the whole population}
\usage{
MLCSW (ysA, ysB, pik_A, pik_B, pik_ab_B, pik_ba_A, domains_A, domains_B, xsA, xsB,
 x, ind_sam, N_A, N_B, N_ab = NULL, met = "linear", conf_level = NULL)
}
\arguments{
\item{ysA}{A data frame containing information about one or more factors, each one of dimension \eqn{n_A}, collected from \eqn{s_A}.}

\item{ysB}{A data frame containing information about one or more factors, each one of dimension \eqn{n_B}, collected from \eqn{s_B}.}

\item{pik_A}{A numeric vector of length \eqn{n_A} containing first order inclusion probabilities for units included in \eqn{s_A}.}

\item{pik_B}{A numeric vector of length \eqn{n_B} containing first order inclusion probabilities for units included in \eqn{s_B}.}

\item{pik_ab_B}{A numeric vector of size \eqn{n_A} containing first order inclusion probabilities according to sampling design in frame B for units belonging 
to overlap domain that have been selected in \eqn{s_A}.}

\item{pik_ba_A}{A numeric vector of size \eqn{n_B} containing first order inclusion probabilities according to sampling design in frame A for units belonging 
to overlap domain that have been selected in \eqn{s_B}.}

\item{domains_A}{A character vector of size \eqn{n_A} indicating the domain each unit from \eqn{s_A} belongs to. Possible values are "a" and "ab".}

\item{domains_B}{A character vector of size \eqn{n_B} indicating the domain each unit from \eqn{s_B} belongs to. Possible values are "b" and "ba".}

\item{xsA}{A numeric vector of length \eqn{n_A} or a numeric matrix or data frame of dimensions \eqn{n_A} x \eqn{m}, with \eqn{m} the number of auxiliary variables, containing auxiliary information in frame A for units included in \eqn{s_A}.}

\item{xsB}{A numeric vector of length \eqn{n_B} or a numeric matrix or data frame of dimensions \eqn{n_B} x \eqn{m}, with \eqn{m} the number of auxiliary variables, containing auxiliary information in frame B for units included in \eqn{s_B}.}

\item{x}{A numeric vector or length \eqn{N} or a numeric matrix or data frame of dimensions \eqn{N} x \eqn{m}, with \eqn{m} the number of auxiliary variables, containing auxiliary information for every unit in the population.}

\item{ind_sam}{A numeric vector of length \eqn{n = n_A + n_B} containing the identificators of units of the population (from 1 to \eqn{N}) that belongs to \eqn{s_A} or \eqn{s_B}}

\item{N_A}{A numeric value indicating the size of frame A}

\item{N_B}{A numeric value indicating the size of frame B}

\item{N_ab}{(Optional) A numeric value indicating the size of the overlap domain}

\item{met}{(Optional) A character vector indicating the distance that must be used in calibration process. Possible values are "linear", "raking" and "logit". Default is "linear".}

\item{conf_level}{(Optional) A numeric value indicating the confidence level for the confidence intervals, if desired.}
}
\value{
\code{MLCSW} returns an object of class "MultEstimatorDF" which is a list with, at least, the following components:
 \item{Call}{the matched call.}
 \item{Est}{class frequencies and proportions estimations for main variable(s).}
}
\description{
Produces estimates for class totals and proportions using multinomial logistic regression from survey data obtained
 from a dual frame sampling design using a model calibrated single frame approach with auxiliary information from the whole population. Confidence intervals are also computed, if required.
}
\details{
Multinomial logistic calibration estimator in single frame using auxiliary information from the whole population for a proportion is given by
 \deqn{\hat{P}_{MLCi}^{SW} = \frac{1}{N} \left(\sum_{k \in s_A \cup s_B} \tilde{w}_k z_{ki}\right) \hspace{0.3cm} i = 1,...,m}
 with \eqn{m} the number of categories of the response variable, \eqn{z_i} the indicator variable for the i-th category of the response variable,
 and \eqn{\tilde{w}} calibration weights which are calculated having into account a different set of constraints, depending on the case. For instance, if \eqn{N_A, N_B} and \eqn{N_{ab}} are known, calibration constraints are
 \deqn{\sum_{k \in s_a}\tilde{w}_k = N_a, \sum_{k \in s_{ab} \cup s_{ba}}\tilde{w}_k = N_{ab}, \sum_{k \in s_{ba}}\tilde{w}_k = N_{ba}} and \deqn{\sum_{k \in s_A \cup s_B}\tilde{w}_k \tilde{p}_{ki} = \sum_{k \in U} \tilde{p}_{ki}}
with \deqn{\tilde{p}_{ki} = \frac{exp(x_k^{'}\tilde{\beta_i})}{\sum_{r=1}^m exp(x_k^{'}\tilde{\beta_r})},}
being \eqn{\tilde{\beta_i}} the maximum likelihood parameters of the multinomial logistic model considering weights \eqn{\tilde{d}_k =\left\{\begin{array}{lcc}
 d_k^A & \textrm{if } k \in a\\
 (1/d_k^A + 1/d_k^B)^{-1} & \textrm{if } k \in ab \cup ba \\
 d_k^B & \textrm{if } k \in b
 \end{array}
 \right.}.
}
\examples{
data(DatMA)
data(DatMB)
data(DatPopM) 

IndSample <- c(DatMA$Id_Pop, DatMB$Id_Pop)
N_FrameA <- nrow(DatPopM[DatPopM$Domain == "a" | DatPopM$Domain == "ab",])
N_FrameB <- nrow(DatPopM[DatPopM$Domain == "b" | DatPopM$Domain == "ab",])
N_Domainab <- nrow(DatPopM[DatPopM$Domain == "ab",])
#Let calculate proportions of categories of variable Prog using MLCSW estimator
#using Read as auxiliary variable
MLCSW(DatMA$Prog, DatMB$Prog, DatMA$ProbA, DatMB$ProbB, DatMA$ProbB, DatMB$ProbA,
DatMA$Domain, DatMB$Domain, DatMA$Read, DatMB$Read, DatPopM$Read, IndSample, N_FrameA, 
N_FrameB)

#Now, let suppose that the overlap domian size is known
MLCSW(DatMA$Prog, DatMB$Prog, DatMA$ProbA, DatMB$ProbB, DatMA$ProbB, DatMB$ProbA,
DatMA$Domain, DatMB$Domain, DatMA$Read, DatMB$Read, DatPopM$Read, IndSample, N_FrameA, 
N_FrameB, N_Domainab)

#Let obtain 95\% confidence intervals together with the estimations
MLCSW(DatMA$Prog, DatMB$Prog, DatMA$ProbA, DatMB$ProbB, DatMA$ProbB, DatMB$ProbA,
DatMA$Domain, DatMB$Domain, DatMA$Read, DatMB$Read, DatPopM$Read, IndSample, N_FrameA, 
N_FrameB, N_Domainab, conf_level = 0.95)
}
\references{
Molina, D., Rueda, M., Arcos, A. and Ranalli, M. G. (2015)
 \emph{Multinomial logistic estimation in dual frame surveys}
 Statistics and Operations Research Transactions (SORT). To be printed.
}
\seealso{
\code{\link{JackMLCSW}}
}

