% Generated by roxygen2: do not edit by hand
% Please edit documentation in R/DrugFormulation.R
\name{hypothesis_testing}
\alias{hypothesis_testing}
\title{Perform hypothesis testing}
\usage{
hypothesis_testing(formulation_data)
}
\arguments{
\item{formulation_data}{A data frame containing the formulation data.}
}
\value{
The results of the hypothesis testing.
}
\description{
This function conducts hypothesis testing to compare means between different formulation groups.
}
\examples{
formulation_data <- data.frame(
  Formulation_Type = sample(c("Type A", "Type B"), 100, replace = TRUE),
  Drug_Release = rnorm(100, mean = 50, sd = 10)
)
hypothesis_testing(formulation_data)
}
