% Generated by roxygen2: do not edit by hand
% Please edit documentation in R/forecast_eval_functions.R
\name{dm.test.wpe.fb}
\alias{dm.test.wpe.fb}
\title{Diebold-Mariano Test (WPE, fixed-m approximation)}
\usage{
dm.test.wpe.fb(d, M = NA, Mopt = NA, cl = 0.05)
}
\arguments{
\item{d}{loss differential}

\item{M}{truncation parameter for the WPE long-run variance estimator (if \code{M = NA}, then \code{Mopt = 1} by default)}

\item{Mopt}{option for automatic bandwidth, 1 if Coroneo and Iacone's default value (M = floor(T^(1/3)))}

\item{cl}{confidence level (default = 0.05, i.e., 5\%)}
}
\value{
This function returns a class with the following elements
\itemize{
\item \code{rej} is a T/F value. TRUE (reject), FALSE (accept)
\item \code{stat} is a test statistic
\item \code{pval} is an associated p-value
}
}
\description{
Diebold-Mariano Test (WPE, fixed-m approximation). This is a two-sided test. See Coroneo and Iacone (2020)
}
\author{
Minchul Shin
}
