% Generated by roxygen2: do not edit by hand
% Please edit documentation in R/FDinterfaces.R
\name{FD.generate}
\alias{FD.generate}
\title{The Flexible Dirichlet Random Generation}
\usage{
FD.generate(n, a, p, t)
}
\arguments{
\item{n}{number of points on the simplex to be generated.}

\item{a}{vector of the non-negative alpha parameters.}

\item{p}{vector of the clusters' probabilities. It must sum to one.}

\item{t}{non-negative scalar tau parameter.}
}
\description{
Random generation from the Flexible Dirichlet distribution with parameters \code{a}, \code{p} and \code{t}.
}
\details{
Vectors \code{a} and \code{p} must be of the same length.
The Flexible Dirichlet distribution derives from the normalization of a basis of positive dependent random variables obtained by starting from a basis of independent equally scaled gamma random variables, and randomly allocating to the \code{i}-th element a further independent gamma random variable.
}
\examples{
n <- 100
alpha <- c(12,7,15)
prob <- c(0.3,0.4,0.3)
tau <- 8
data <- FD.generate(n,alpha,prob,tau)
data

}
\references{
{
 Ongaro, A. and Migliorati, S. (2013) A generalization of the Dirichlet distribution. Journal of Multivariate Analysis, \bold{114}, 412--426.\cr
\cr
 Migliorati, S., Ongaro, A. and Monti, G. S. (2016) A structured Dirichlet mixture model for compositional data: inferential and applicative issues. Statistics and Computing, 1--21.
}
}
\seealso{
\code{\link{FD.estimation}}, \code{\link{FD.density}}, \code{\link{FD.theorcontours}}, \code{\link{FD.subcomposition}}, \code{\link{FD.amalgamation}}
}
