% Generated by roxygen2: do not edit by hand
% Please edit documentation in R/FDinterfaces.R
\name{FD.estimation}
\alias{FD.estimation}
\title{Flexible Dirichlet Estimation}
\usage{
FD.estimation(data, normalize = F, iter.initial.SEM = 50,
  iter.final.EM = 100, verbose = T)
}
\arguments{
\item{data}{a matrix or a dataframe containing only the variables in the model. Rows must sum to one, or \code{normalize} must be set \code{TRUE}.}

\item{normalize}{if \code{TRUE}, each row of \code{data} will be divided by its own total to become a point of the simplex. Values in \code{data} must be positive.}

\item{iter.initial.SEM}{number of iterations for the initial SEM step. Default to 50.}

\item{iter.final.EM}{number of iterations for the final EM step. Default to 100.}

\item{verbose}{if \code{TRUE}, the progression of the elaboration and the results will be printed on screen.}
}
\value{
an object of class FDfitted. It's a list composed by:
\describe{
  \item{\code{alpha}}{Estimated values of the parameter vector Alpha}
  \item{\code{p}}{Estimated values of the parameter vector P}
  \item{\code{tau}}{Estimated value of the parameter Tau}
  \item{\code{logL}}{LogLikelihood}
  \item{\code{data}}{Normalized dataset}
}
}
\description{
Estimates the vector of parameters of a Flexible Dirichlet distribution through an EM-based maximum likelihood approach.
}
\details{
The procedure is made up of four stages:
\enumerate{
  \item Clustering: The algorithm applies many different clustering rules to the dataset, in order to exploit the specific cluster patterns that the parameter structure of the model involves.
  \item Labelling: Once the initial partitions are obtained, group labeling needs to be established because any clustering algorithm assigns the group labels randomly, but the FD cluster structure entails a precise labelling scheme.
  \item Initial SEM: A Stochastic E-M algorithm is applied at every initial partition and every possible label permutation identified.
  \item Final E-M: The previous step must be seen as a multiple initialization strategy. At this point only the best one is selected and a final E-M algorithm is used to find the point that maximizes the likelihood of the parameter vector.
}
}
\examples{
data <- FD.generate(n=20,a=c(12,7,15),p=c(0.3,0.4,0.3),t=8)
data
results <- FD.estimation(data, normalize=TRUE,iter.initial.SEM = 5,iter.final.EM = 10)
results
summary(results)

}
\references{
{
 Ongaro, A. and Migliorati, S. (2013) A generalization of the Dirichlet distribution. Journal of Multivariate Analysis, \bold{114}, 412--426.\cr
\cr
 Migliorati, S., Ongaro, A. and Monti, G. S. (2016) A structured Dirichlet mixture model for compositional data: inferential and applicative issues. Statistics and Computing, doi:10.1007/s11222-016-9665-y.
}
}
\seealso{
\code{\link{FD.generate}}, \code{\link{FD.stddev}}, \code{\link{FD.aicbic}}, \code{\link{FD.barycenters}}, \code{\link{FD.ternaryplot}}, \code{\link{FD.rightplot}}, \code{\link{FD.marginalplot}}
}
