% Generated by roxygen2: do not edit by hand
% Please edit documentation in R/FDist.R
\name{FDist}
\alias{FDist}
\title{Fit of univariate distributions with censored data ignored by default or can be inputed.}
\usage{
FDist(X, gen = 1, Cont = TRUE, inputNA, plot = FALSE,
  p.val_min = 0.05, crit = 2, DPQR = TRUE)
}
\arguments{
\item{X}{A random sample to be fitted.}

\item{gen}{A positive integer, indicates the sample length to be generated by the fit, 1 by default.}

\item{Cont}{TRUE, by default the distribution is considered as continuos.}

\item{inputNA}{A number to replace censored values, if is missing, only non-censored values will be evaluated.}

\item{plot}{FALSE. If TRUE, a plot showing the data distribution will be given.}

\item{p.val_min}{0.05, minimum p.value for Anderson Darling and KS Test to non-reject the null hypothesis and continue with the process.}

\item{crit}{A positive integer to define which test will use. If 1, show the distributions which were non-rejected by the Anderson Darling or Kolmogorov Smirnov tests, in other cases the criterion is that they mustn't be rejected by both tests.}

\item{DPQR}{TRUE, creates the distribution function, density and quantile function with the names dfit, pfit and qfit.}
}
\value{
Calculate the distribution name with parameters, a function to reproduce random values from that distribution, a numeric vector of random numbers from that function, Anderson Darling and KS p.values, a plot showing the distribution difference between the real sample and the generated values and a list with the random deviates genetator, the distribution function, density and quantile function
}
\description{
Fit of univariate distributions with censored data ignored by default or can be inputed.
}
\examples{
set.seed(31109)
FIT1<-FDist(rnorm(1000,10),p.val_min=.03,crit=1,plot=TRUE)

#Random Variable
FIT1[[1]]

#Random numbers generator
FIT1[[2]]()

#Random sample
FIT1[[3]]

#Goodness of fit tests results
FIT1[[4]]

#Plot
FIT1[[5]]

#Functions r, p, d, q
FIT1[[6]]



}
