% Generated by roxygen2: do not edit by hand
% Please edit documentation in R/6_pca_results.R
\name{pca_scores}
\alias{pca_scores}
\title{Calculate Principal Component Analysis Scores not including depth statistics}
\usage{
pca_scores(
  pc_results = results,
  plot_loadings = TRUE,
  every_nth = 12,
  output = FALSE,
  output_folder = NULL,
  verbose = FALSE
)
}
\arguments{
\item{pc_results}{PCA class object containing the output from the
'pca_results()' function.}

\item{plot_loadings}{TRUE or FALSE. Plot PC loadings figures. Default TRUE.}

\item{every_nth}{Numeric. Sequence of labels to show on mean power plot.
Default is 12.}

\item{output}{Logical. If TRUE, output is saved to \code{output_folder}.
Defaults to FALSE.}

\item{output_folder}{Output folder path. If \code{output = TRUE},
\code{output_folder} must be provided. Defaults to NULL.}

\item{verbose}{Logical. If TRUE, progress messages are shown. Defaults to FALSE.}
}
\value{
A data frame of pc scores containing one column for each Principal
Component kept. If processing just one tag, the attribute 'unique_tag_ID'
is given to the data frame with the tag_ID. Plots the PC loadings for each
row of pc_data
}
\description{
This function extracts the PCA scores from the PCA results and plots the
loadings. This function is to be use on output from the \code{pca_data()} function
not including depth statistics.
}
\examples{
# Set file path
filepath <- system.file("extdata", package = "FishDiveR")

# Load pc_results
pc_results <- readRDS(file.path(filepath, "data/4_PCA/pc_results.rds"))

# Run pca_scores function
pc_scores <- pca_scores(
  pc_results = pc_results,
  plot_loadings = FALSE,
  every_nth = 12,
  output = TRUE,
  output_folder = tempdir(),
  verbose = TRUE
)

}
