% Generated by roxygen2: do not edit by hand
% Please edit documentation in R/FundamentalFactor.Cov.R
\name{FundamentalFactor.Cov}
\alias{FundamentalFactor.Cov}
\title{Covariance Matrix Estimation by Fundamental Factor Model}
\usage{
FundamentalFactor.Cov(assets, exposure, method = "WLS")
}
\arguments{
\item{assets}{a N*p matrix of asset returns, N indicates sample size
and p indicates the dimension of asset returns}

\item{exposure}{a p*q matrix of exposure indicator for the
fundamental factor model, p corresponds to the dimension of
asset returns, q indicates the number of fundamental industries}

\item{method}{a character, indicating regression method: "OLS" or "WLS"}
}
\value{
an estimated p*p covariance matrix
}
\description{
Estimate covariance matrix by fitting a fundamental factor model
using OLS or WLS regression
}
\examples{
data(m.excess.c10sp9003)
assets <- m.excess.c10sp9003[,1:10]
Indicator <- matrix(0,10,3)
dimnames(Indicator) <- list(colnames(assets),c("Drug","Auto","Oil"))
Indicator[c("ABT","LLY","MRK","PFE"),"Drug"] <- 1
Indicator[c("F","GM"),"Auto"] <- 1
Indicator[c("BP","CVX","RD","XOM"),"Oil"] <- 1
FundamentalFactor.Cov(assets,exposure=Indicator,method="WLS")
}

