% Generated by roxygen2: do not edit by hand
% Please edit documentation in R/plot_effects.R
\name{theoretical_variogram}
\alias{theoretical_variogram}
\title{Theoretical variogram}
\usage{
theoretical_variogram(
  ncols = 10,
  nrows = 20,
  varR = 1,
  col.cor = 0.5,
  row.cor = 0.7,
  prop.spatial = 1
)
}
\arguments{
\item{ncols}{A scalar defining the number of columns.}

\item{nrows}{A scalar defining the number of rows.}

\item{varR}{A scalar defining the error variance.}

\item{col.cor}{A scalar defining the column autocorrelation,}

\item{row.cor}{A scalar defining the row autocorrelation.}

\item{prop.spatial}{A scalar defining the proportion of spatial trend.}
}
\value{
A theoretical variogram with x- and y-axes displaying the row and column displacements,
  and the z-axis displaying the semivariances (variogram ordinates) for a separable autoregressive process.
}
\description{
Creates a theoretical variogram for a separable first order autoregressive (AR1) process.
}
\examples{
# Theoretical variogram for a field trial with 10 columns and 20 rows, based
# on column and row autocorrelations of 0.5 and 0.7, and a proportion of
# spatial trend of 0.5. The remaining proportion represents random error.

variogram <- theoretical_variogram(
  ncols = 10,
  nrows = 20,
  varR = 1,
  col.cor = 0.5,
  row.cor = 0.7,
  prop.spatial = 0.5
)

# Theoretical variogram
variogram

# Extract the data frame with the column and row displacements, and the
# theoretical semivariances.
variogram_df <- variogram$data

}
