% Generated by roxygen2: do not edit by hand
% Please edit documentation in R/compare.two.sample.R
\name{compare.two.sample}
\alias{compare.two.sample}
\title{Two sample bootstrap test for comparing different in \code{sample1} and \code{sample2}, not necessary with same sample size}
\usage{
compare.two.sample(sample1, sample2, fun = mean, R = 1000)
}
\arguments{
\item{sample1}{first sample}

\item{sample2}{second sample}

\item{fun}{statistic (univariate) to be compared (default: \code{mean})}

\item{R}{number of resamples (default: \code{1000})}
}
\value{
\code{compare.two.sample} return a list with two components, namely,
\code{p.value}: two tailed p-value for the bootstrap test
\code{object}: a "\code{simpleboot}" object allowing further analysis using other R packages, such as \code{boot})
}
\description{
Two sample bootstrap test for comparing different in \code{sample1} and \code{sample2}, not necessary with same sample size
}
\examples{

set.seed(1203)
# compare median of two expontential r.v.
compare.two.sample(rexp(100, rate=1), rexp(100, rate=2), fun=median, R=1e3)$p.value

f.Q1 <- function(x) quantile(x, probs=0.25)
compare.two.sample(rnorm(100, mean=0), rnorm(200, mean=0.5), fun=f.Q1, R=1e3)$p.value

}
