% Generated by roxygen2: do not edit by hand
% Please edit documentation in R/summary.R
\name{summary.krr}
\alias{summary.krr}
\title{Summary method for fitted Kernel Ridge Regression models}
\usage{
\method{summary}{krr}(object, ...)
}
\arguments{
\item{object}{An S3 object of class \code{krr}, typically returned by
\code{\link{fastkrr}}.}

\item{...}{Additional arguments (currently ignored).}
}
\value{
A human-readable summary of the fitted KRR model to the console.
}
\description{
Displays key information from a fitted Kernel Ridge Regression (KRR) model,
including the original call, first few coefficients, a 6×6 block of the
kernel (or approximated kernel) matrix, and the main kernel options.
}
\examples{
# Data setting
set.seed(1)
lambda = 1e-4
d = 1
n = 50
rho = 1
X = matrix(runif(n*d, 0, 1), nrow = n, ncol = d)
y = as.vector(sin(2*pi*rowMeans(X)^3) + rnorm(n, 0, 0.1))

# Example: exact
model = fastkrr(X, y,
                kernel = "gaussian", opt = "exact",
                rho = rho, lambda = 1e-4)
class(model)

summary(model)

}
\seealso{
\code{\link{fastkrr}}
}
