% Generated by roxygen2: do not edit by hand
% Please edit documentation in R/generate_fake_data.R
\name{generate_fake_data}
\alias{generate_fake_data}
\title{Generate Fake Data from Real Dataset Structure}
\usage{
generate_fake_data(
  data,
  n = 30,
  category_mode = c("preserve", "generic", "custom"),
  numeric_mode = c("range", "distribution"),
  column_mode = c("keep", "generic", "custom"),
  custom_levels = NULL,
  custom_names = NULL,
  seed = NULL,
  verbose = FALSE,
  sensitive = NULL,
  sensitive_detect = TRUE,
  sensitive_strategy = c("fake", "drop"),
  normalize = TRUE
)
}
\arguments{
\item{data}{A tabular object; will be coerced via \code{prepare_input_data()}.}

\item{n}{Rows to generate (default 30).}

\item{category_mode}{One of "preserve","generic","custom".
\itemize{
\item preserve: sample observed categories by empirical frequency (keeps factors)
\item generic: replace categories with "Category A/B/..."
\item custom: use \code{custom_levels[[colname]]} if provided
}}

\item{numeric_mode}{One of "range","distribution".
\itemize{
\item range: uniform between min/max (integers stay integer-like)
\item distribution: sample observed values with replacement
}}

\item{column_mode}{One of "keep","generic","custom".
\itemize{
\item keep: keep original column names
\code{var1..varP} (mapping in \code{attr(name_map)})
\item custom: use \code{custom_names} named vector (old -> new)
}}

\item{custom_levels}{optional named list of allowed levels per column (for}

\item{custom_names}{optional named character vector old->new (for
\code{column_mode="custom"}).}

\item{seed}{Optional RNG seed.}

\item{verbose}{Logical; print progress.}

\item{sensitive}{Optional character vector of original column names to treat as sensitive.}

\item{sensitive_detect}{Logical; auto-detect common sensitive columns by name.}

\item{sensitive_strategy}{One of "fake","drop". Only applied if any sensitive columns exist.}

\item{normalize}{Logical; lightly normalize inputs (trim, \%→numeric, short date-times→POSIXct).}
}
\value{
A data.frame of n rows with attributes:
\itemize{
\item \code{name_map} (named chr: original -> output)
\item \code{column_mode} (chr)
\item \code{sensitive_columns} (chr; original names)
\item \code{dropped_columns} (chr; original names that were dropped)
}
}
\description{
Generate Fake Data from Real Dataset Structure
}
