\name{analyze_design}
\alias{analyze_design}
\title{Analyze properties of a blocked factorial design with given number of levels of factors and block contents}
\usage{analyze_design(factor_levels, blocks)}
\arguments{
\item{factor_levels}{a numeric vector with positive entries, elements denoting levels of factors}
\item{blocks}{a list of numeric vectors of same size, each vector representing individual block contents of a factorial design. }
}
\examples{
blocks = as.matrix(autogenerate_design(2,c(3,4),3,2))
blocks = lapply(seq_len(ncol(blocks)), function(i) blocks[, i])
analyze_design(c(3,4), blocks)}
\value{Returns factorial designs properties such as block sizes, replications of treatments, orthogonal factorial structure or not, efficiencies of main effects and interactions}
\description{Returns factorial designs properties such as block sizes, replications of treatments, orthogonal factorial structure or not, efficiencies of main effects and interactions}

