% Generated by roxygen2: do not edit by hand
% Please edit documentation in R/FFTreesdata_doc.R
\docType{data}
\name{fertility}
\alias{fertility}
\title{Fertility data}
\format{
A data frame containing 100 rows and 10 columns.

\describe{
  \item{season}{Season in which the analysis was performed. (winter, spring, summer, fall)}
  \item{age}{Age at the time of analysis}
  \item{child.dis}{Childish diseases (ie , chicken pox, measles, mumps, polio) (yes(1), no(0)) }
  \item{trauma}{Accident or serious trauma (yes(1), no(0))}
  \item{surgery}{Surgical intervention (yes(1), no(0))}
  \item{fevers}{High fevers in the last year (less than three months ago(-1), more than three months ago (0), no. (1))}
  \item{alcohol}{Frequency of alcohol consumption (several times a day, every day, several times a week, once a week, hardly ever or never)}
  \item{smoking}{Smoking habit (never(-1), occasional (0)) daily (1))}
  \item{sitting}{Number of hours spent sitting per day}
  \item{diagnosis}{\emph{Criterion}: Diagnosis normal (TRUE) vs. altered (FALSE) (88.0\% vs.\ 22.0\%).}
}
}
\source{
\url{https://archive.ics.uci.edu/ml/datasets/Fertility}

Original contributors:

David Gil
Lucentia Research Group
Department of Computer Technology
University of Alicante

Jose Luis Girela
Department of Biotechnology
University of Alicante
}
\usage{
fertility
}
\description{
This dataset describes a sample of 100 volunteers providing a semen sample that was analyzed according to the WHO 2010 criteria.
}
\details{
Sperm concentration are related to socio-demographic data, environmental factors, health status, and life habits.

We made the following enhancements to the original data for improved usability:

\itemize{
 \item{The criterion was redefined from a factor variable with two levels
 (\code{N = Normal}, \code{O = Altered}) into a logical variable (\code{TRUE} vs. \code{FALSE}).}
 }

 Other than that, the data remains consistent with the original dataset.
}
\seealso{
Other datasets: 
\code{\link{blood}},
\code{\link{breastcancer}},
\code{\link{car}},
\code{\link{contraceptive}},
\code{\link{creditapproval}},
\code{\link{forestfires}},
\code{\link{heart.cost}},
\code{\link{heart.test}},
\code{\link{heart.train}},
\code{\link{heartdisease}},
\code{\link{iris.v}},
\code{\link{mushrooms}},
\code{\link{sonar}},
\code{\link{titanic}},
\code{\link{voting}},
\code{\link{wine}}
}
\concept{datasets}
\keyword{datasets}
