% Generated by roxygen2: do not edit by hand
% Please edit documentation in R/GLForces.2d.R
\name{GLForces.2d}
\alias{GLForces.2d}
\title{GLForces.2d}
\usage{
GLForces.2d(meshP, meshT, GMat, GlobalND, EMatrixlist)
}
\arguments{
\item{meshP}{Matrix (2 x n) containing coordinate points of the mesh nodes.}

\item{meshT}{Matrix (3 x n) containing the number of the coordinate point that forms a given triangle within the mesh.}

\item{GMat}{Global matrix}

\item{GlobalND}{Global nodal displacement}

\item{EMatrixlist}{Element matrix list}
}
\value{
Matrices of global and local forces
\item{GForce}{Large global force matrix.}
\item{Lforce}{Large local force matrix.}
}
\description{
Uses nodal displacements to determine global and local forces at each node
}
\examples{
data(triMesh)
data(gloMat)
data(displacN)
data(fea_EM)

meshP = triMesh$MeshPts$p
meshT = triMesh$MeshPts$T
GMat = gloMat
GlobalND = displacN$GlobalND
EMatrixlist = fea_EM$EMPStress

glfor = GLForces.2d(meshP, meshT, GMat, GlobalND, EMatrixlist)

}
