% Generated by roxygen2: do not edit by hand
% Please edit documentation in R/EulerBeamFEA.R
\name{EulerBeamFEA}
\alias{EulerBeamFEA}
\title{EulerBeamFEA}
\usage{
EulerBeamFEA(Y, beamP, beamT, fx, fy, BCtran, BCrot, Length, MoI, RotAng)
}
\arguments{
\item{Y}{Elastic modulus value for material (Pa).}

\item{beamP}{Matrix (2 x n) of beam coordinates.}

\item{beamT}{Matrix (2 x n) containing the number of the coordinate point as shown in beamP that connect to form a given beam (Discretization table).}

\item{fx}{Load value (newtons) in the x direction.}

\item{fy}{Load value (newtons) in the y direction.}

\item{BCtran}{Boundary constraint for nodes to translate in x or y directions. Input as a non-matrix column.}

\item{BCrot}{Boundary constraint for nodes to rotate. Input as a non-matrix column.}

\item{Length}{Length of beam.}

\item{MoI}{Moment of inertia for each beam segment.}

\item{RotAng}{Angle of rotation}
}
\value{
Calculates local forces and stresses, as well as bending stress for beams following the Euler-Bernoulli beam theory.
\item{Stress}{Local stress at node}
\item{LocalLoad}{Local load at node}
\item{BendingStress}{Bending Stress}
}
\description{
Calculates stress in beam structures using the Euler-Bernoulli beam theory.
}
\examples{
data(beamGeo)
data(beamDime)

Length = beamDime$Length
MoI = beamDime$MomentofInertia
RotAng = beamDime$Angle

beamFEA = EulerBeamFEA(beamGeo$Y, beamGeo$beamP, beamGeo$beamT, beamGeo$fx, beamGeo$fy,
                       beamGeo$BCtran, beamGeo$BCrot, Length, MoI, RotAng)

}
