% Generated by roxygen2: do not edit by hand
% Please edit documentation in R/power.R
\name{power.li}
\alias{power.li}
\title{Compute power for RNA-Seq experiments assuming Poisson distribution}
\usage{
power.li(n, alpha, rho, mu0, w, type)
}
\arguments{
\item{n}{per-group sample size}

\item{alpha}{p-value threshold (scalar)}

\item{rho}{fold-change, usual null hypothesis is that rho=1 (vector)}

\item{mu0}{average count in control group}

\item{w}{ratio of the total number of reads mapped between the two groups}

\item{type}{type of test: "w" for Wald, "s" for score, "lw" for log-transformed Wald, "ls" for log-transformed score}
}
\value{
Vector of power estimates for two-sided tests
}
\description{
Use the formula of Li et al (2013) to compute power for comparing RNA-seq expression across two groups assuming the Poisson distribution
}
\details{
This function computes the power for each of a series of two-sided tests defined by the input parameters. The power is based on the sample size formulas in equations (10-13) of Li et al (2013). Also, note that the null.effect is set to 1 in the examples because the usual null hypothesis is that the fold-change = 1.
}
\examples{
power.li(n = 88, alpha = 0.05, rho = 1.25, mu0 = 5, w = 0.5,type = "w")
# recapitulate 80\% power in Table 1 of Li et al (2013)
}
\references{
C-I Li, P-F Su, Y Guo, and Y Shyr (2013). Sample size calculation for differential expression analysis of RNA-seq data under Poisson distribution. Int J Comput Biol Drug Des 6(4). <doi:10.1504/IJCBDD.2013.056830>
}
