% Generated by roxygen2: do not edit by hand
% Please edit documentation in R/fcum.R
\name{fcum}
\alias{fcum}
\title{Fourier CUSUM Cointegration Test}
\usage{
fcum(y, x, kstar = 3)
}
\arguments{
\item{y}{Numeric vector or matrix. Dependent variable time series.}

\item{x}{Numeric vector or matrix. Independent variable(s) time series.
Must have the same number of observations as y.}

\item{kstar}{Positive numeric value. Maximum frequency parameter for
Fourier approximation. Determines the flexibility of structural break
modeling. Default is 3.}
}
\value{
An object of class \code{fcum} containing:
\describe{
  \item{statistic}{The CUSUM test statistic}
   \item{critical_values}{Critical values at 1\%, 5\%, and 10\% significance levels}
  \item{p}{Number of regressors used for critical value lookup}
  \item{k}{Frequency parameter used for critical value lookup}
  \item{kstar}{Maximum frequency parameter (user input)}
  \item{best_frequency}{Optimal frequency selected by AICc criterion}
  \item{decision}{Test decision (reject or fail to reject null hypothesis)}
  \item{significance}{Significance level indicator (*, **, ***)}
  \item{best_model}{The best fitting lm model object}
  \item{call}{The matched function call}
}
}
\description{
Implements the Fourier CUSUM test for cointegration with structural breaks.
The test uses Fourier approximations to model smooth structural changes and
applies CUSUM statistics to test for cointegration stability.
}
\details{
The null hypothesis is that there exists a cointegrating relationship with
stable parameters. The alternative hypothesis is that the cointegrating
relationship is unstable or does not exist.

The test searches over a grid of frequencies from 0.1 to \code{kstar} and
selects the optimal frequency using the corrected Akaike Information
Criterion (AICc). The CUSUM statistic is then computed from the residuals
of the best model.

Critical values are based on simulation studies and depend on:
\itemize{
  \item The number of regressors (p)
  \item The frequency parameter (k)
}
}
\examples{
# Generate sample data
set.seed(123)
n <- 100
x <- cumsum(rnorm(n))
y <- 2 + 1.5 * x + rnorm(n)

# Run the test
result <- fcum(y, x, kstar = 3)
print(result)
summary(result)

}
\references{
Zaghdoudi, T. (2025). Fourier CUSUM Cointegration Test Methodology.
}
