% Generated by roxygen2: do not edit by hand
% Please edit documentation in R/predict.R
\name{predict.mjmcmc}
\alias{predict.mjmcmc}
\title{Predict Using an MJMCMC Result Object}
\usage{
\method{predict}{mjmcmc}(
  object,
  x,
  link = function(x) x,
  quantiles = c(0.025, 0.5, 0.975),
  x_train = NULL,
  ...
)
}
\arguments{
\item{object}{The model to use.}

\item{x}{The new data to use for the prediction, a matrix where each row is an observation.}

\item{link}{The link function to use}

\item{quantiles}{The quantiles to calculate credible intervals for the posterior modes (in model space).}

\item{x_train}{Training design matrix to be provided when imputations are to be made from them}

\item{...}{Not used.}
}
\value{
A list containing aggregated predictions.
\item{mean}{Mean of aggregated predictions.}
\item{quantiles}{Quantiles of aggregated predictions.}
}
\description{
Predict Using an MJMCMC Result Object
}
\examples{
result <- mjmcmc(
x = matrix(rnorm(600), 100),
y = matrix(rnorm(100), 100),
loglik.pi = gaussian.loglik)
preds <- predict(result, matrix(rnorm(600), 100))

}
