% Generated by roxygen2: do not edit by hand
% Please edit documentation in R/predict.R
\name{plot.fbms_predict}
\alias{plot.fbms_predict}
\title{Plot FBMS Prediction Object}
\usage{
\method{plot}{fbms_predict}(x, ...)
}
\arguments{
\item{x}{Object of class "fbms_predict".}

\item{...}{Additional arguments passed to plot.}
}
\value{
Plots the predictions and returns NULL.
}
\description{
Plots the mean predictions and quantile intervals from an FBMS prediction object, with quantiles in varying shades of grey.
}
\examples{
\donttest{
data(exoplanet)
model <- fbms(semimajoraxis ~ ., data = exoplanet)
pred <- predict(model, exoplanet[51:60, -1], 
quantiles = c(0.025, 0.1, 0.5, 0.9, 0.975))
plot(pred)
}
}
