% Generated by roxygen2: do not edit by hand
% Please edit documentation in R/get_most_distant_function.R
\name{get.most.distant}
\alias{get.most.distant}
\title{Get Most Distant Model}
\usage{
get.most.distant(input = getwd(), mrun = NULL, max.number = 100)
}
\arguments{
\item{input}{Either a string containing the directory which holds the "FAMoS-Results" folder or a matrix containing the tested models along with the respective information criteria. Default to \code{getwd()}.}

\item{mrun}{A string giving the number of the corresponding FAMoS run, e.g "004". If NULL (default), all FAMoS runs in the "FAMoS-Results/TestedModels/" folder will be used for evaluation.}

\item{max.number}{The maximum number of times that the \code{get.most.distant} function tries to find the most distant model (see details). Default to 100.}
}
\value{
A list containing in its first entry the maximal distance found, the second entry the parameter names and in its third entry the corresponding binary vector. Note that the model may not fulfill previously specified critical conditions.
}
\description{
This function can be used to find a model that is most distinct from all previously tested models.
}
\details{
Taking the order from the 'TestedModels' files found in 'FAMoS-Results/TestedModels/', this function successively tries to obtain a previously untested model that is most distant from all previously tested ones (here, distance means the number of difference in fitted parameters). To this end, the function collects all previously tested models and sorts them according to their information criterion value (duplicates get removed in the process). Starting with the best model, the corresponding complement model is generated (i.e. the model containing all parameters that the best model didn't use) and the distance to all other models is calculated. The total distance of this model is then taken to be the minimal distance of all calculated distances. This procedure is repeated for the second best model and so on until all models have been assessed or the \code{max.number} of models is reached.
}
\examples{
get.most.distant(input = famos.run)
}
