% Generated by roxygen2: do not edit by hand
% Please edit documentation in R/Factmle_cov.R
\name{Factmle_cov}
\alias{Factmle_cov}
\title{Calculates the Maximum likelihood Factor analysis with a covariance Matrix.}
\usage{
Factmle_cov(S, rnk, Psi_init = c(), lb = 0.01, index = c(), lb2 = 0.01,
  tol = 10^-7, Max_iter = 1000)
}
\arguments{
\item{S}{The Covariance Matrix. It is a p*p numeric matrix, where p is the number of variables.}

\item{rnk}{Rank constraint for the Factor analysis problem. It must a positive integer less than the number of variables p}

\item{Psi_init}{The initial value of Psi. It is a p*1 numeric vetor, where p is the number of variables.Default value is a vector of uniform random numbers.}

\item{lb}{The lower bound on the Psi values. The default value is set to 0.05}

\item{index}{This option is for modified version of factmle.The default value is a null vector. If assigned a zero vector, it will perform MLFA keeping some of the Psi 
values specified by the index at a specifed level *lb2*}

\item{lb2}{This option of modified version of factmle algorithm. The default value is 0.001. The Psi values 
specified by the *index* is kept constant at *lb2* while doing MLFA.}

\item{tol}{Precision parameter. Default is 10^-7}

\item{Max_iter}{Maximum number of iterations. Default is 1000.}
}
\value{
A list with the following components
\describe{
\item{Psi}{A vector containing the unique variances.}
\item{Lambda}{A p*rnk matrix containing the factor loadings in the columns.}
\item{Nll}{A vector containing the negative Log-likelihood values at every iteration.}
\item{Nllopt}{The value of the negative log-likelihood upon convergence.}
}
}
\description{
Calculates the Maximum likelihood Factor analysis with a covariance Matrix.
}
\examples{


library(MASS)
library(stats)
Psi=runif(15,min=0.2,max=1.3)
Lambda=mvrnorm(n=15,mu=rep(0,3),Sigma = diag(rep(1,3)))
data=mvrnorm(n=5000,mu=rep(0,15),Sigma = diag(Psi)+Lambda\%*\%t(Lambda))
S=cov(data)
x=Factmle_cov(S,3)


}
\seealso{
\code{eigs_sym}
}

