% Generated by roxygen2: do not edit by hand
% Please edit documentation in R/fabtzCI.R
\name{sfabz}
\alias{sfabz}
\title{Bayes-optimal spending function}
\usage{
sfabz(theta, psi, alpha = 0.05)
}
\arguments{
\item{theta}{value of theta being tested}

\item{psi}{a list of parameters for the spending function, including 
\enumerate{
\item mu, the prior expectation of E[y]
\item tau2, the prior variance of E[y]
\item sigma2 the variance of y
}}

\item{alpha}{level of test}
}
\value{
a scalar value giving the optimal tail-area probability
}
\description{
Compute Bayes optimal spending function
}
\details{
This function computes the 
value of s that minimizes the acceptance probability of a 
biased level-alpha test for a normal population with 
known variance, under a specified  prior
predictive distribution.
}
\examples{
thetas<-seq(-1,1,length=100)  
s<-NULL 
for(theta in thetas){ s<-c(s,sfabz(theta,list(mu=0,tau2=1,sigma2=1)) ) }  
plot(thetas,s,type="l") 

}
\author{
Peter Hoff
}
