% Generated by roxygen2: do not edit by hand
% Please edit documentation in R/rssSplit.R
\name{rssSplit}
\alias{rssSplit}
\title{Residual sum of squares split}
\usage{
rssSplit(fit, df0 = max(1, floor(fit$df/10)), seed = -71407)
}
\arguments{
\item{fit}{lm object}

\item{df0}{degrees of freedom for the smaller of the two residual sums of squares}

\item{seed}{random seed for constructing the basis vectors of the split}
}
\value{
a two-dimensional vector of independent sums of squares
}
\description{
Split residual sum of squares from normal linear regression
}
\examples{
n<-30 ; p<-6 ; sigma2<-1.5 
X<-matrix(rnorm(n*p),n,p) 
y<-X\%*\%rnorm(6) + sqrt(sigma2)*rnorm(n) 
ss<-rssSplit(lm(y~ -1+X)) 
df<-as.numeric( substring(names(ss),first=3)) 
ss/df

}
\author{
Peter Hoff
}
