% Generated by roxygen2: do not edit by hand
% Please edit documentation in R/glmFAB.R
\name{glmFAB}
\alias{glmFAB}
\title{FAB inference for generalized linear models}
\usage{
glmFAB(cformula, FABvars, lformula = NULL, alpha = 0.05,
  silent = FALSE, ...)
}
\arguments{
\item{cformula}{formua for the control variables}

\item{FABvars}{matrix of regressors for which to make FAB p-values and CIs}

\item{lformula}{formula for the lining model (just specify right-hand side)}

\item{alpha}{error rate for CIs (1-alpha CIs will be constructed)}

\item{silent}{show progress (TRUE) or not (FALSE)}

\item{...}{additional arguments to be passed to \code{glm}}
}
\value{
an object of the class \code{glmFAB} which inherits from \code{glm}
}
\description{
asymptotic FAB p-values and confidence intervals for parameters
in generalized linear regression models
}
\examples{

# n observations, p FAB variables, q=2 control variables 

n<-100 ; p<-25 

# X is design matrix for params of interest
# beta is vector of true parameter values 
# v a variable in the linking model - used to share info across betas

v<-rnorm(p) ; beta<-(2 - 2*v + rnorm(p))/3 ; X<-matrix(rnorm(n*p),n,p)/8

# control coefficients and variables  
alpha1<-.5 ; alpha2<- -.5
w1<-rnorm(n)/8
w2<-rnorm(n)/8

# simulate data 
lp<-1 + alpha1*w1 + alpha2*w2 + X\%*\%beta 
y<-rpois(n,exp(lp))

# fit model
fit<-glmFAB(y~w1+w2,X,~v,family=poisson)

fit$FABpv
fit$FABci 
summary(fit) # look at p-value column 

}
\author{
Peter Hoff
}
