% Generated by roxygen2: do not edit by hand
% Please edit documentation in R/fractional_factorial_efficiency.R
\name{fractional_factorial_efficiency}
\alias{fractional_factorial_efficiency}
\title{Fractional Factorial Design Efficiency}
\usage{
fractional_factorial_efficiency(formula, searched_fractional_factorial)
}
\arguments{
\item{formula}{A specification, in formula form, of the desired effects sought to be estimated.}

\item{searched_fractional_factorial}{a fractional factorial generated as the result of a `search_design`.}
}
\value{
a list with the following objects:
1. X - This is the formula expanded version of the fractional factorial which was passed to the function.
2. information_mat - This is the information matrix described by the associated note. Note: it is rounded to three decimal places to ease reading.
3. inv_information_mat - This is the inverse of the information matrix. Note: it is rounded to three decimal places to ease reading.
4. lamda_mat - This is the diagonal elements of the Lamda Matrix described by Kuhfeld (pg. 62). The elements are the eigen values of the inv_information_mat.
5. inv_diag - This is the diagonal elements of the inv_information_mat. (May be of use to some researchers...)
6. GWLP - This is the generalised world lengths for the searched design. (Note: this would not change depending on what is in the formula expansion.)
7. A_eff - This is the A-efficiency of the design given the particular formula expansion.
8. D_eff - This is the D-efficiency of the design given the particular formula expansion.
}
\description{
Fractional Factorial Design Efficiency
}
\examples{
# See step 5 of the Practical Introduction to ExpertChoice vignette.

# Step 1
attrshort  = list(condition = c("0", "1", "2"),
technical =c("0", "1", "2"),
provenance = c("0", "1"))

#Step 2
# ff stands for "full fatorial"
 ff  <-  full_factorial(attrshort)
 af  <-  augment_levels(ff)
# af stands for "augmented factorial"

# Step 3
# Choose a design type: Federov or Orthogonal. Here an Orthogonal one is used.
nlevels <- unlist(purrr::map(ff, function(x){length(levels(x))}))
fractional_factorial <- DoE.base::oa.design(nlevels = nlevels, columns = "min34")

# Step 4
# The functional draws out the rows from the original augmented full factorial design.
colnames(fractional_factorial) <- colnames(ff)
fractional <- search_design(ff, fractional_factorial)

# Step 5! - The fractional_factorial_efficiency function
# The formula requires reference to the original attributes of the design.
# Check for the main effects.
fractional_factorial_efficiency(~ condition + technical + provenance, fractional)
# Check for the main effects with some interaction.
fractional_factorial_efficiency(~ condition + technical * provenance, fractional)
}
\references{
Kuhfeld, W. F. Marketing Research Methods in SAS Experimental Design, Choice, Conjoint, and Graphical Techniques 2010.
}
