% Generated by roxygen2: do not edit by hand
% Please edit documentation in R/sRNA_length_distribution.R
\name{lenplot}
\alias{lenplot}
\title{Plot the length distribution diagram for small RNAs (sRNAs)}
\usage{
lenplot(sRNAdata, type, width = 0.6, font_size = 10, title_size = 12)
}
\arguments{
\item{sRNAdata}{A data frame. Frequency distribution of sRNAs in different length.}

\item{type}{A character. "bar" or "line".}

\item{width}{A numeric. Bar width, and default is 0.6. if the type is "line", the parameter does not need to be given.}

\item{font_size}{A numeric. Size of axis ticks and legend item labels, and default is 10.}

\item{title_size}{A numeric. Size of axis titles and legend titles, and default is 12.}
}
\value{
Length distribution plot of sRNAs.
}
\description{
There are two types of pictures: bar plot (type = "bar") and line plot (type = "line"). For the bar plot, the Y-axis displays the proportion of sRNAs in a certain length, the X-axis represents sRNAs in different length. And for line plot, the Y-axis displays the abundance of sRNAs in a certain length, the X-axis represents sRNAs in different length.
}
\examples{
#P1(B.napus)
B.napu_sRNA <- srnapredata(sRNAseq = P1_sRNA_seq,Group = "B.napus(AACC)")
#P2(B.rapa)
B.rapa_sRNA <- srnapredata(sRNAseq = P2_sRNA_seq,Group = "B.rapa(AA)")
#F1(B.napus X B.rapa)
B.nr_sRNA <- srnapredata(sRNAseq = F1_sRNA_seq,Group = "B.napus x B.rapa(AAAACC)")
#intergrate these data for length distribution plot
sRNA_data <- rbind(B.napu_sRNA,B.rapa_sRNA,B.nr_sRNA)
#plot
lenplot(sRNAdata = sRNA_data,type = "line")
lenplot(sRNAdata = sRNA_data,type = "bar")
}
