% Generated by roxygen2: do not edit by hand
% Please edit documentation in R/srna_filiter.R
\name{Countfilter}
\alias{Countfilter}
\title{Filtering out lowly expressed genes based on count}
\usage{
Countfilter(
  P1_count,
  P2_count,
  F1_count,
  type,
  homoeologs,
  count_threshold = 5
)
}
\arguments{
\item{P1_count}{A data frame. The count table of genes in P1 species. For the count table, the first column is the gene identifier, and other columns are read counts of the gene in each biological replicate.}

\item{P2_count}{A data frame. The count table of genes in P2 species.}

\item{F1_count}{A data frame. The count table of genes in F1 species.}

\item{type}{A character. "sRNA" or "mRNA".}

\item{homoeologs}{A data frame. Orthologous relationships of genes within the parental species and their progeny. Only required when the 'type' is 'mRNA'.}

\item{count_threshold}{A numeric. Threshold for filtering out the lowly expressed genes. The default is 5 (the count values in all replicates).}
}
\value{
A data frame.
}
\description{
Regarding the criteria for filtering out lowly expressed genes, no less than the count threshold in all replicates.
}
\details{
The 'homoeologs' table contains the orthologs pairs. In detail, the first column is the group name (unique) of homoeologs among three species (Parents: P1; P2, Progeny: F1), the second column is the Gene ID of P1, the third column is the Gene ID of P2. And the fourth column and fifth columns are the identifier of F1 orthologs derived from P1 and P2 ancestors, respectively (e.g. "Homoeolog1	BraA01t00004Z	BolC01g000040.2J BnA01g0000030.1 BnC01g0424620.1").
}
\examples{
Count5result <- Countfilter(P1_count = P1_miRNA_count,
                            P2_count = P2_miRNA_count,
                            F1_count = F1_miRNA_count,
                            type = "sRNA", count_threshold = 5)
}
