# Generated by using Rcpp::compileAttributes() -> do not edit by hand
# Generator token: 10BE3573-1514-4C36-9D1C-5A225CD40393

#' @title C++ Function for Exact Multinomial Test
#' @export
#' 
#' @description C++ function computing exact multinomial p-values. Does not perform any safety checks. Incorrect input may result in unwanted behavior.
#' Use only through \code{\link{multinom.test}} with method = "exact" is recommended.
#' 
#' @param x Vector of non-negative integers - number of times each outcome was observed.
#' @param p A vector of positive numbers - the hypothesized probabilities for each outcome. Need to sum to 1!
#' @param theta Parameter - p-values less than theta will not be determined precisely.
#' 
#' @details The outcomes should be ordered by the hypothesized probabilities from largest to smallest for optimal performance.
#' 
#' @return Returns a vector containing three values which are the p-values computed from the probability mass, Pearson's chi-square and the log-likelihood ratio statistic.
#' Values below the threshold theta are upper bounds only and not exact p-values!
#' 
#' @seealso \code{\link{multinom.test}}
#' 
multinom_test_cpp <- function(x, p, theta = 0.0001) {
    .Call(`_ExactMultinom_multinom_test_cpp`, x, p, theta)
}

