% Generated by roxygen2: do not edit by hand
% Please edit documentation in R/freqdist.evaluate.core.R
\name{freqdist.evaluate.core}
\alias{freqdist.evaluate.core}
\title{Frequency Distribution Histogram}
\usage{
freqdist.evaluate.core(
  data,
  names,
  quantitative,
  qualitative,
  selected,
  highlight = NULL,
  include.highlight = TRUE,
  highlight.se = NULL,
  highlight.col = "red",
  show.count = FALSE
)
}
\arguments{
\item{data}{The data as a data frame object. The data frame should possess
one row per individual and columns with the individual names and multiple
trait/character data.}

\item{names}{Name of column with the individual names as a character string.}

\item{quantitative}{Name of columns with the quantitative traits as a
character vector.}

\item{qualitative}{Name of columns with the qualitative traits as a character
vector.}

\item{selected}{Character vector with the names of individuals selected in
core collection and present in the \code{names} column.}

\item{highlight}{Individual names to be highlighted as a character vector.}

\item{include.highlight}{If \code{TRUE}, the highlighted individuals are
included in the frequency distribution histogram. Default is \code{TRUE}.}

\item{highlight.se}{Optional data frame of standard errors for the
individuals specified in \code{highlight}. It should have the same column
names as in \code{data}.}

\item{highlight.col}{The colour(s) to be used to highlighting individuals in
the plot as a character vector of the same length as \code{highlight}. Must
be valid colour values in R (named colours, hexadecimal representation,
index of colours [\code{1:8}] in default R \code{palette()} etc.).}

\item{show.count}{logical. If \code{TRUE}, the accession count excluding
missing values will also be displayed. Default is \code{FALSE}.}
}
\value{
A list with the \code{ggplot} objects of stacked frequency
  distribution histograms plots for each trait specified as
  \code{quantitative} and \code{qualitative}.
}
\description{
Plot stacked frequency distribution histogram to graphically compare the
probability distributions of traits between entire collection (EC) and core
set (CS).
}
\examples{

data("cassava_CC")
data("cassava_EC")

ec <- cbind(genotypes = rownames(cassava_EC), cassava_EC)
ec$genotypes <- as.character(ec$genotypes)
rownames(ec) <- NULL

core <- rownames(cassava_CC)

quant <- c("NMSR", "TTRN", "TFWSR", "TTRW", "TFWSS", "TTSW", "TTPW", "AVPW",
           "ARSR", "SRDM")
qual <- c("CUAL", "LNGS", "PTLC", "DSTA", "LFRT", "LBTEF", "CBTR", "NMLB",
          "ANGB", "CUAL9M", "LVC9M", "TNPR9M", "PL9M", "STRP", "STRC",
          "PSTR")

ec[, qual] <- lapply(ec[, qual],
                     function(x) factor(as.factor(x)))

\donttest{
freqdist.evaluate.core(data = ec, names = "genotypes",
                       quantitative = quant, qualitative = qual,
                       selected = core)

checks <- c("TMe-1199", "TMe-1957", "TMe-3596", "TMe-3392")

freqdist.evaluate.core(data = ec, names = "genotypes",
                       quantitative = quant, qualitative = qual,
                       selected = core,
                       highlight = checks, highlight.col = "red")

quant.se <- data.frame(genotypes = checks,
                       NMSR = c(0.107, 0.099, 0.106, 0.062),
                       TTRN = c(0.081, 0.072, 0.057, 0.049),
                       TFWSR = c(0.089, 0.031, 0.092, 0.097),
                       TTRW = c(0.064, 0.031, 0.071, 0.071),
                       TFWSS = c(0.106, 0.071, 0.121, 0.066),
                       TTSW = c(0.084, 0.045, 0.066, 0.054),
                       TTPW = c(0.098, 0.052, 0.111, 0.082),
                       AVPW = c(0.074, 0.038, 0.054, 0.061),
                       ARSR = c(0.104, 0.019, 0.204, 0.044),
                       SRDM = c(0.078, 0.138, 0.076, 0.079))

freqdist.evaluate.core(data = ec, names = "genotypes",
                       quantitative = quant,
                       selected = core,
                       highlight = checks, highlight.col = "red",
                       highlight.se = quant.se)

freqdist.evaluate.core(data = ec, names = "genotypes",
                       quantitative = quant, qualitative = qual,
                       selected = core,
                       highlight = checks, highlight.col = "red",
                       show.count = TRUE)
}

}
\seealso{
\code{\link[graphics]{hist}}, \code{\link[ggplot2]{geom_histogram}}
}
