% Generated by roxygen2: do not edit by hand
% Please edit documentation in R/summate.R
\name{summate}
\alias{summate}
\title{Summation of One-Dimensional Functions}
\usage{
summate(fun, lower, upper, tol = 1e-10, ...)
}
\arguments{
\item{fun}{an \strong{R} function which should take a numeric argument x and
possibly some parameters. The function returns a numerical vector
value for the given argument \code{x}.}

\item{lower}{a numeric value for the lower limit of the integral.}

\item{upper}{a numeric value for the upper limit of the integral.}

\item{tol}{a numeric value indicating the accuracy of the result (useful in
infinite summations).}

\item{...}{additional arguments to be passed to \code{fun}.}
}
\description{
\ifelse{html}{\href{https://lifecycle.r-lib.org/articles/stages.html#experimental}{\figure{lifecycle-experimental.svg}{options: alt='[Experimental]'}}}{\strong{[Experimental]}}

Discrete summation of functions of one variable over a finite or semi-infinite
interval.
}
\details{
Arguments after \code{...} must be matched exactly. If both limits are infinite,
the function fails. For semi-infinite intervals, the summation must be convergent.
This is accomplished in manny probability mass functions.
}
\examples{
library(EstimationTools)


#----------------------------------------------------------------------------
# Example 1: Poisson expected value computation, X ~ Poisson(lambda = 15)
Poisson_integrand <- function(x, lambda) {
  x * lambda^x * exp(-lambda)/factorial(x)
}

summate(fun = Poisson_integrand, lower = 0, upper = Inf, lambda = 15)


#----------------------------------------------------------------------------

}
\author{
Jaime Mosquera Gutiérrez, \email{jmosquerag@unal.edu.co}
}
