% Generated by roxygen2: do not edit by hand
% Please edit documentation in R/LinkFunc.R
\encoding{UTF-8}
\name{logit_link}
\alias{logit_link}
\title{Logit link function (for estimation with \code{maxlogL} object)}
\usage{
logit_link()
}
\value{
A list with logit link function, its inverse and its name.
}
\description{
\ifelse{html}{\href{https://lifecycle.r-lib.org/articles/stages.html#experimental}{\figure{lifecycle-experimental.svg}{options: alt='[Experimental]'}}}{\strong{[Experimental]}}

\code{log_link} object provides a way to implement logit link function that
\code{\link{maxlogL}} needs to perform estimation. See documentation for
\code{\link{maxlogL}} for further information on parameter estimation and implementation
of link objects.
}
\details{
\code{logit_link} is part of a family of generic functions with no input arguments that
defines and returns a list with details of the link function:
\enumerate{
\item \code{name}: a character string with the name of the link function.
\item \code{g}: implementation of the link function as a generic function in \code{R}.
\item \code{g_inv}: implementation of the inverse link function as a generic function
in \code{R}.
}

There is a way to add new mapping functions. The user must specify the details aforesaid.
}
\examples{
#--------------------------------------------------------------------------------
# Estimation of proportion in binomial distribution with 'logit' function
# 10 trials, probability of success equals to 30\%)
N <- rbinom(n = 100, size = 10, prob = 0.3)
phat <- maxlogL(x = N, dist = 'dbinom', fixed = list(size=10),
                link = list(over = "prob", fun = "logit_link"))
summary(phat)

# Link function name
fun <- logit_link()$name
print(fun)

# Link function
g <- logit_link()$g
curve(g(x), from = 0, to = 1)

# Inverse link function
ginv <- logit_link()$g_inv
curve(ginv(x), from = -10, to = 10)

#--------------------------------------------------------------------------------

}
\seealso{
\code{\link{maxlogL}}

Other link functions: 
\code{\link{NegInv_link}()},
\code{\link{log_link}()}
}
\author{
Jaime Mosquera Gutiérrez, \email{jmosquerag@unal.edu.co}
}
\concept{link functions}
