% Generated by roxygen2: do not edit by hand
% Please edit documentation in R/hazard_fun.R
\encoding{UTF-8}
\name{cum_hazard_fun}
\alias{cum_hazard_fun}
\title{Cumulative hazard functions for any distribution}
\usage{
cum_hazard_fun(
  distr,
  support = NULL,
  method = c("log_sf", "integration"),
  routine = NULL
)
}
\arguments{
\item{distr}{a length-one character vector with the name of density/mass function
of interest.}

\item{support}{a list with the following entries:
\itemize{
\item \code{interval}: a two dimensional atomic vector
indicating the set of possible values of a random variable
having the distribution specified in \code{y_dist}.
\item \code{type}: character indicating if distribution has a
\code{discrete} or a \code{continous} random variable.
}}

\item{method}{a character or function; if \code{"log_sf"}, the cumulative
hazard function (CHF) is computed using the expression
\eqn{H(t) = -\log (S(t))}; if \code{"integrate_hf"}, the CHF is
computed with the integral of the hazard function.}

\item{routine}{a character specifying the integration routine.
\code{integrate} and \code{gauss_quad} are available for
continuous distributions, and \code{summate} for discrete ones.
Custom routines can be defined but they must be compatible
with the \code{\link{integration}} API.}
}
\value{
A function with the following input arguments:
\item{x}{vector of (non-negative) quantiles.}
\item{...}{Arguments of the probability density/mass function.}
}
\description{
\ifelse{html}{\href{https://lifecycle.r-lib.org/articles/stages.html#experimental}{\figure{lifecycle-experimental.svg}{options: alt='[Experimental]'}}}{\strong{[Experimental]}}

This function takes a \code{maxlogL} hazard function and computes the
cumulative hazard function.
}
\examples{
library(EstimationTools)

#----------------------------------------------------------------------------
# Example 1: Cumulative hazard function of the Weibull distribution.
support <- list(interval=c(0, Inf), type='continuous')

# Cumuative hazard function in the 'maxlogL' framework
Hweibull1 <- cum_hazard_fun(
  distr = 'dweibull',
  support = support,
  method = "integration"
 )

 Hweibull2 <- cum_hazard_fun(
  distr = 'dweibull',
  method = "log_sf"
 )

# Compute cumulative hazard function from scratch
# Recall h(x) = shape/scale * (x/scale)^(shape - 1), then
# H(x) = (x/scale)^shape

Hweibull3 <- function(x, scale, shape){
  (x/scale)^shape
}

# Comparison
Hweibull1(0.2, shape = 2, scale = 1)  # using H(t) = -log(S(t))
Hweibull2(0.2, shape = 2, scale = 1)  # integrating h(t)
Hweibull3(0.2, shape = 2, scale = 1)  # raw version


#----------------------------------------------------------------------------

}
\seealso{
Other distributions utilities: 
\code{\link{expected_value}()},
\code{\link{hazard_fun}()}
}
\author{
Jaime Mosquera Gutiérrez, \email{jmosquerag@unal.edu.co}
}
\concept{distributions utilities}
