% Generated by roxygen2: do not edit by hand
% Please edit documentation in R/validation.R
\name{simulate_trajectory}
\alias{simulate_trajectory}
\title{Simulate Trajectory from SDE}
\usage{
simulate_trajectory(
  sde,
  initial_conditions,
  times,
  n_sims = 100,
  method = c("euler", "milstein", "rk4"),
  exogenous_data = NULL,
  seed = NULL
)
}
\arguments{
\item{sde}{SDE object from \code{construct_sde} or \code{estimate_sde_iterative}.}

\item{initial_conditions}{Named vector of initial values for all variables.}

\item{times}{Numeric vector of time points.}

\item{n_sims}{Number of Monte Carlo simulations (for stochastic models).}

\item{method}{Integration method: "euler", "milstein", "rk4" (deterministic only).}

\item{exogenous_data}{Data frame with exogenous variable trajectories (if any).}

\item{seed}{Random seed for reproducibility.}
}
\value{
Object of class "trajectory_simulation" containing:
\item{trajectories}{Array of simulated trajectories (time x variable x simulation)}
\item{times}{Time points}
\item{summary}{Summary statistics (mean, quantiles) at each time}
}
\description{
Simulates trajectories using the discovered SDE to assess whether the model
can reproduce observed dynamics.
}
\examples{
\donttest{
# Toy example: dX = 0.5 * X
# Mock SDE object structure
sde <- list(
  drift = list(expression = "0.5 * X"),
  diffusion = list(expression = "0.1"), # Add noise
  variable = "X"
)
class(sde) <- "sde_model"

# Simulation
sim <- simulate_trajectory(
  sde = sde,
  initial_conditions = c(X = 1),
  times = seq(0, 1, by = 0.1),
  n_sims = 10,
  seed = 123
)
print(sim$summary$mean)
}
}
