% Generated by roxygen2: do not edit by hand
% Please edit documentation in R/makepairwise.R
\name{makepairwise}
\alias{makepairwise}
\title{transform preference data}
\usage{
makepairwise(winner, loser, rater)
}
\arguments{
\item{winner}{character, vector with the IDs of the winning (preferred) stimuli}

\item{loser}{character, vector with the IDs of the losing (not preferred) stimuli}

\item{rater}{character, vector of rater identity}
}
\value{
object of class \code{paircomp}
}
\description{
transform preference data into paircomp format (\code{\link[psychotools:paircomp]{paircomp}})
}
\examples{
w <- c("B", "A", "E", "E", "D", "D", "A", "D", "E", "B", "A", "E", "D", "C", "A")
l <- c("C", "C", "C", "D", "B", "C", "E", "A", "B", "D", "E", "B", "E", "D", "C")
raters <- rep(letters[1:3], 5)
makepairwise(w, l, raters)
}
\seealso{
\code{\link[psychotools:paircomp]{psychotools}}
}
\author{
Christof Neumann
}
