% Generated by roxygen2: do not edit by hand
% Please edit documentation in R/traditional_indexes.R
\name{traditional_indexes}
\alias{traditional_indexes}
\title{Traditional indexes for measuring deviations from proportionality}
\usage{
traditional_indexes(votes, seats)
}
\arguments{
\item{votes}{A vector of length p (where p the number of parties) with the votes gained by each party in the election.
When blank or null votes are included in \code{votes}, they are
treated in the same way as the other parties.}

\item{seats}{A vector of length p (where p the number of parties) with components in the same order as \code{votes},
with the seats gained by each party/candidacy in the election.}
}
\value{
A data.frame of order 10x3 with the Rae, Loosemore-Handy, Gallagher, Monroe, Sainte-Lague,
Entropy, Taagepera-Laasko-v, Taagepera-Laasko-s, Taagapera-Shugart, Pessini-Gini and
Pavia-Gini indexes.
}
\description{
Computes a list of indexes proposed in the literature to measure the seat-to-vote deviations from proportionality. (See the \code{malapportionment_index} function for the Samuels and Snyder’s index).
}
\note{
The Entropy index (EI) only considers parties gaining seats.
}
\examples{
votes.ex <- c(Party1 = 6310391, Party2 = 5371866, Party3 = 1709890,
              Party4 = 1504771, Party5 = 323444)

seats.ex <- c(Party1 = 165, Party2 = 118, Party3 = 20,
              Party4 = 16, Party5 = 0)

example <- traditional_indexes(votes.ex, seats.ex)
example

}
\references{
Riera, P and Penades, A \emph{Indices of Disproportionality}. Elgar Encyclopedia of Political Representation (Eds. A Freire, A Pedrazzani & H Schmit). Cheltenham: Edgar Elgar Publishing.

Taagepera, R and Shugart, MS (1991) \emph{Seats and Votes: The Effects and Determinants of Electoral Systems}. New Haven: Yale University Press.
}
\author{
Alberto Penades, \email{alberto.penades@gmail.com}

Jose M. Pavia, \email{pavia@uv.es}
}
