% Generated by roxygen2: do not edit by hand
% Please edit documentation in R/read_ePIRLS.R
\name{read_ePIRLS}
\alias{read_ePIRLS}
\title{Connect to ePIRLS Data}
\usage{
read_ePIRLS(path, countries, forceReread = FALSE, verbose = TRUE)
}
\arguments{
\item{path}{a character value to the full directory path to the ePIRLS extracted SPSS (.sav) set of data}

\item{countries}{a character vector of the country/countries to include using
the three-digit ISO country code.
A list of country codes can be found on Wikipedia at
\url{https://en.wikipedia.org/wiki/ISO_3166-1#Current_codes}
or other online sources. Consult the \emph{ePIRLS User Guide} to help determine what countries
are included within a specific testing year of ePIRLS.
To select all countries, use a wildcard value of \strong{\code{*}}.}

\item{forceReread}{a logical value to force rereading of all processed data.
The default value of \code{FALSE} will speed up the \code{read_ePIRLS} function by
using existing read-in data already processed.}

\item{verbose}{a logical value to either print or suppress status message output.
The default value is \code{TRUE}.}
}
\value{
an \code{edsurvey.data.frame} for a single specified country or an
\code{edsurvey.data.frame.list} if multiple countries are specified
}
\description{
Opens a connection to an ePIRLS data file and
             returns an \code{edsurvey.data.frame} with
             information about the file and data.
}
\details{
Reads in the unzipped files downloaded from the ePIRLS international
database(s) using the \href{https://www.iea.nl/data-tools/repository}{IEA Study Data Repository}.
Data files require the SPSS data file (.sav) format using the default filenames.

An ePIRLS \code{edsurvey.data.frame} includes three distinct data levels:
         \itemize{
              \item student
              \item school
              \item teacher
         }

         When the \code{getData} function is called using an ePIRLS \code{edsurvey.data.frame},
         the requested data variables are inspected, and it handles any necessary data merges automatically.
         The \code{school} data always will be returned merged to the \code{student}
         data, even if only \code{school} variables are requested.
         If \code{teacher} variables are requested by the \code{getData} call, it will cause \code{teacher} data to be merged.
         A \code{student} can be linked to many \code{teachers}, which varies widely between countries.

Please note that calling the \code{dim} function for an ePIRLS \code{edsurvey.data.frame} will result in
         the row count as if the \code{teacher} dataset was merged.
         This row count will be considered the \code{full data N} of the \code{edsurvey.data.frame}, even if no \code{teacher} data were included in an analysis.
         The column count returned by \code{dim} will be the count of unique column variables across all three data levels.
}
\examples{
\dontrun{
usa <- read_ePIRLS("~/ePIRLS/2016", countries = c("usa"))
gg <- getData(data=usa, varnames=c("itsex", "totwgt", "erea"))
head(gg)
edsurveyTable(formula=erea ~ itsex, data=usa)
}
}
\seealso{
\code{\link{readNAEP}}, \code{\link{readTIMSS}}, \code{\link{getData}}, and \code{\link{download_ePIRLS}}
}
\author{
Tom Fink
}
