% Generated by roxygen2: do not edit by hand
% Please edit documentation in R/methods.R
\name{rlbl}
\alias{rlbl}
\alias{rlbl,binClst-method}
\title{Manual relabeling of clusters.}
\usage{
rlbl(obj, old = 0, new = 0, reset = FALSE)

\S4method{rlbl}{binClst}(obj, old = 0, new = 0, reset = FALSE)
}
\arguments{
\item{obj}{A \link{binClst_instance}.}

\item{old}{The number of the cluster to be relabeled.}

\item{new}{The new number of the cluster.}

\item{reset}{A boolean value (defaults to FALSE). If reset=TRUE the labeling
is reset to the original state.}
}
\value{
This method does not return a relabeled copy of the input
  \code{obj}, instead the \link{binClst_instance} itself is relabeled. It is
  intended only for visualization purposes, as it does not recompute the GMM
  parameters nor the binary delimiters of the \link{binClst_instance}.
}
\description{
\code{rlbl} Manual relabeling of clusters (to merge clusters or
  relabel merged clusters).
}
\details{
Whenever two adjacent clusters are merged, the label identifying the
splitting variable between them both is meaningless, and the algorithm ends
up assigning either a L or H only depending on how it evolved until reaching
the merging point. Thus it can happen that the final labeling of the
resulting cluster is not the most intuitive one. With this method the labels
can be changed as desired. It can also be used to manually force the merging
of two clusters.

This method does not return a relabeled copy of the input \code{obj},
instead the \link{binClst_instance} itself is relabeled. However, this is
intended only for output and visualization purposes (sctr(), lblp(),
cnfm(), view()) as the \link{binClst_instance} parameters (GMM parameters and
binary delimiters) are not recomputed. Thus the input instance can always be
reset to its original state.
}
\examples{
# -- apply EMbC to the example path --
mybcp <- stbc(expth,info=-1)
# -- manually merge clusters 1 and 2 --
rlbl(mybcp,1,2)
# -- reset to the original state --
rlbl(mybcp,reset=TRUE)
}
