% Generated by roxygen2: do not edit by hand
% Please edit documentation in R/rlabel.R
\name{rlabel}
\alias{rlabel}
\title{Generation of a missing-data indicator}
\usage{
rlabel(dat, pi, mu, sigma, ncov = 2, xi)
}
\arguments{
\item{dat}{An \eqn{n\times p} matrix where each row represents an individual observation.}

\item{pi}{A g-dimensional vector for the initial values of the mixing proportions.}

\item{mu}{A \eqn{p \times g} matrix for the initial values of the location parameters.}

\item{sigma}{A \eqn{p\times p} covariance matrix if \code{ncov=1}, or a list of g covariance matrices with dimension \eqn{p\times p \times g} if \code{ncov=2}.}

\item{ncov}{Options of structure of sigma matrix;  the default value is 2;
\code{ncov} = 1 for a common covariance matrix;
\code{ncov} = 2 for the unequal  covariance/scale matrices.}

\item{xi}{A 2-dimensional coefficient vector for a logistic function of the Shannon entropy.}
}
\value{
\item{m}{A n-dimensional vector of missing label indicator. The element of  outputs \code{m} represents its label indicator is missing if m equals 1, otherwise its label indicator is available if m equals to 0.}
}
\description{
Generate the missing label indicator
}
\examples{
n<-150
pi<-c(0.25,0.25,0.25,0.25)
sigma<-array(0,dim=c(3,3,4))
sigma[,,1]<-diag(1,3)
sigma[,,2]<-diag(2,3)
sigma[,,3]<-diag(3,3)
sigma[,,4]<-diag(4,3)
mu<-matrix(c(0.2,0.3,0.4,0.2,0.7,0.6,0.1,0.7,1.6,0.2,1.7,0.6),3,4)
dat<-rmix(n=n,pi=pi,mu=mu,sigma=sigma,ncov=2)
xi<-c(-0.5,1)
m<-rlabel(dat=dat$Y,pi=pi,mu=mu,sigma=sigma,xi=xi,ncov=2)
}
