% Generated by roxygen2: do not edit by hand
% Please edit documentation in R/eml_get.R
\name{eml_get}
\alias{eml_get}
\title{eml_get}
\usage{
eml_get(x, element, from = "list", ...)
}
\arguments{
\item{x}{an EML object or child/descendant object}

\item{element}{name of the element to be extracted.
If multiple occurrences are found, will extract all}

\item{from}{explicit type for the input format. Possible values:
"xml", "json", "list", or "guess" with "list" as the default.}

\item{...}{additional arguments}
}
\description{
eml_get
}
\examples{
\donttest{
f <- system.file("tests", emld::eml_version(), "eml-datasetWithUnits.xml", package = "emld")
eml <- read_eml(f)
eml_get(eml, "physical")
eml_get(eml, "attributeList")

## The first argument need not be an "eml" class, it could be a child element; e.g.
eml_get(eml$dataset$dataTable, "physical")
}
}
