% Generated by roxygen2: do not edit by hand
% Please edit documentation in R/statistics.R
\name{compare_subject}
\alias{compare_subject}
\title{Information Criteria For Each Participant}
\usage{
compare_subject(
  sList,
  stage = "sample",
  filter = 0,
  use_best_fit = TRUE,
  print_summary = TRUE,
  digits = 3,
  return_summary = FALSE,
  n_cores = 1,
  subject = NULL
)
}
\arguments{
\item{sList}{List of samples objects}

\item{stage}{A string. Specifies which stage the samples are to be taken from \code{"preburn"}, \code{"burn"}, \code{"adapt"}, or \code{"sample"}}

\item{filter}{An integer or vector. If it's an integer, iterations up until the value set by \code{filter} will be excluded.
If a vector is supplied, only the iterations in the vector will be considered.}

\item{use_best_fit}{Boolean, defaults to \code{TRUE}, use minimal likelihood or mean likelihood
(whichever is better) in the calculation, otherwise always uses the mean likelihood.}

\item{print_summary}{Boolean (defaults to \code{TRUE}) print tables of model weight results}

\item{digits}{Integer, significant digits in printed table}

\item{return_summary}{Return tables of model weight results}

\item{n_cores}{Number of cores for parallel processing}

\item{subject}{Used to select subset of subjects (integer or character vector)}
}
\value{
List of matrices for each subject of effective number of parameters,
mean deviance, deviance of mean, DIC, BPIC and associated weights.
}
\description{
Returns the BPIC/DIC based model weights for each participant in a list of samples objects
}
\examples{
# For a broader illustration see `compare`.
# Here we just take two times the same model, but normally one would compare
# different models
compare_subject(list(m0 = samples_LNR, m1 = samples_LNR))
}
