% Generated by roxygen2: do not edit by hand
% Please edit documentation in R/interactions.R
\name{interactions}
\alias{interactions}
\title{Importance of interactions and pairs in the model}
\usage{
interactions(xgb_model, data, option = "interactions")
}
\arguments{
\item{xgb_model}{a xgboost or lightgbm model.}

\item{data}{a data table with data used to train the model.}

\item{option}{if "interactions", the table contains interactions,
if "pairs", this table contains all the pairs in the model.
Default "interactions".}
}
\value{
a data table
}
\description{
This function calculates a table with two measures of importance for interactions and pairs in the model.
}
\details{
Available measures:
\itemize{
\item "sumGain" - sum of Gain value in all nodes, in which given variable occurs,
\item "freqency" - number of occurrences in the nodes for given variable.
}

NOTE: Be careful use of this function with \code{option="pairs"} parameter,
      because high gain of pair can be a result of high gain of child variable.
     As strong interactions should be considered only these pairs of variables,
     where variable on the bottom (child) has higher gain than variable on the top (parent).
}
\examples{
library("EIX")
library("Matrix")
sm <- sparse.model.matrix(left ~ . - 1,  data = HR_data)

library("xgboost")
param <- list(objective = "binary:logistic", max_depth = 2)
xgb_model <- xgboost(sm, params = param, label = HR_data[, left] == 1, nrounds = 25, verbose=0)

inter <- interactions(xgb_model, sm, option = "interactions")
inter
plot(inter)

inter <- interactions(xgb_model, sm, option = "pairs")
inter
plot(inter)

\donttest{
library(lightgbm)
train_data <- lgb.Dataset(sm, label =  HR_data[, left] == 1)
params <- list(objective = "binary", max_depth = 2)
lgb_model <- lgb.train(params, train_data, 25)

inter <- interactions(lgb_model, sm, option = "interactions")
inter
plot(inter)

inter <- interactions(lgb_model, sm, option = "pairs")
inter
plot(inter)
}

}
