% Generated by roxygen2: do not edit by hand
% Please edit documentation in R/runGroupsBoot.R
\name{runGroupsBoot}
\alias{runGroupsBoot}
\title{The bootstrap uncertainty analysis for runGroups results}
\usage{
runGroupsBoot(eList, groupResults, nBoot = 100, startSeed = 494817,
  blockLength = 200, jitterOn = FALSE, V = 0.2, run.parallel = FALSE)
}
\arguments{
\item{eList}{named list with at least the Daily, Sample, and INFO dataframes}

\item{groupResults}{data frame returned from \code{\link[EGRET]{runGroups}}}

\item{nBoot}{the maximum number of bootstrap replicates to be used, typically 100}

\item{startSeed}{setSeed value. Defaults to 494817. This is used to make repeatable output.}

\item{blockLength}{integer size of subset, expressed in days.  200 days has been found to be a good choice.}

\item{jitterOn}{logical, if TRUE, adds "jitter" to the data in an attempt to avoid some numerical problems.
Default = FALSE.  See Details below.}

\item{V}{numeric a multiplier for addition of jitter to the data, default = 0.2.}

\item{run.parallel}{logical to run bootstrapping in parallel or not}
}
\value{
eBoot, a named list with bootOut, wordsOut, xConc, xFlux, pConc, pFlux values.
\itemize{
  \item{bootOut is a data frame with the results of the bootstrap test.}
  \item{wordsOut is a character vector describing the results.}
  \item{xConc and xFlux are vectors of length iBoot, of the change in flow normalized concentration
   and flow normalized flux computed from each of the bootstrap replicates.}
  \item{pConc and pFlux are vectors of length iBoot, of the change in flow normalized concentration
   or flow normalized flux computed from each of the bootstrap replicates expressed as \% change.}
}
}
\description{
This function that does the uncertainty analysis for determining the change 
between two groups of years.  The process is virtually 
identical to what is used for \code{\link{runPairsBoot}} which looks at a change
between a pair of years.
}
\details{
In some situations numerical problems are encountered in the bootstrap process, resulting in highly unreasonable spikes in the confidence intervals.
The use of "jitter" can often prevent these problems, but should only be used when it is clearly needed.
It adds a small amount of random "jitter" to the explanatory variables of the WRTDS model.  The V parameter sets the scale of variation in the log discharge values.
The standard deviation of the added jitter is V * standard deviation of Log Q.
The default for V is 0.2.  Larger values should generally be avoided, and smaller values may be sufficient.
}
\examples{
library(EGRET)
eList <- Choptank_eList

\dontrun{
groupResults <- runGroups(eList, 
                          group1firstYear = 1995, 
                          group1lastYear = 2004, 
                          group2firstYear = 2005, 
                          group2lastYear = 2014, 
                          windowSide = 7, wall = TRUE, 
                          sample1EndDate = "2004-10-30", 
                          paStart = 4, paLong = 2, 
                          verbose = FALSE)

# For good analysis, bump up nBoot to about 100:
boot_group_out <- runGroupsBoot(eList, groupResults, nBoot = 10)

boot_message(eList, groupResults, boot_group_out)

plotHistogramTrend(eList, boot_group_out)

}
}
\seealso{
\code{\link{runPairsBoot}}, \code{\link[EGRET]{runGroups}}
}
