EE.Hist <- function(pobl,fun,n,k,tolerance,
                    maxiter,n_gen,...){
  pobl <- as.data.frame(pobl)
  H <- apply(pobl, 2, function(x){
    h <- hist(x, plot = FALSE)
    return(h)
  })
  error <- 1e10
  P <- as.data.frame(sapply(H, function(h) r.hist(n, h)))
  Y <- apply(P, 1, fun,...)
  G <- 0
  historical <- c(min(Y))
  n_gen2 <- 1
  n_gen <- n_gen + 1
  while (G < k & n_gen < maxiter) {
    Q <- as.data.frame(sapply(H, function(h) r.hist(n, h)))
    Z <- apply(Q, 1, fun,...)
    historical <- c(historical,min(Z))
    P <- rbind(P,Q)
    error <- comparison(x = Y, y = c(Y,Z))
    Y <- c(Y,Z)
    n_gen <- n_gen + 1
    n_gen2 <- n_gen2 + 1
    if(error > tolerance){
      G <- 0
    }else{
      G <- G + 1
    }
  }
  best_par <- P[order(Y)[1:n],]
  best_par <- as.data.frame(best_par)
  return(list(par = best_par, Y = Y,n_gen = n_gen,
              par_historical = P,
              historical = historical,n_gen2 = n_gen2))
}



