% Generated by roxygen2: do not edit by hand
% Please edit documentation in R/list_service_methods.R
\name{list_service_methods}
\alias{list_service_methods}
\title{List service methods}
\usage{
list_service_methods(env = "production")
}
\arguments{
\item{env}{(character) Repository environment. Can be: "production",
"staging", or "development".}
}
\value{
(character) A simple list of web service methods supported by the
Data Package Manager web service
}
\description{
List service methods
}
\examples{
\dontrun{

# All service methods
services <- list_service_methods()
services
#>  [1] "appendProvenance"              "createDataPackage"            
#>  [3] "createDataPackageArchive"      "createReservation"            
#>  [5] "deleteReservation"             "deleteDataPackage"            
#>  [7] "evaluateDataPackage"           "getProvenanceMetadata"        
#>  [9] "isAuthorized"                  "listActiveReservations"       
#> [11] "listDataEntities"              "listDataDescendants"          
#> [13] "listDataSources"               "listRecentChanges"            
#> [15] "listDataPackageIdentifiers"    "listDataPackageRevisions"     
#> [17] "listDataPackageScopes"         "listDeletedDataPackages"      
#> [19] "listRecentUploads"             "listReservationIdentifiers"   
#> [21] "listServiceMethods"            "listUserDataPackages"         
#> [23] "listWorkingOn"                 "readDataEntity"               
#> [25] "readDataEntityAcl"             "readDataEntityRmd"            
#> [27] "readDataEntityChecksum"        "readDataEntityDoi"            
#> [29] "readDataEntityName"            "readDataEntityNames"          
#> [31] "readDataEntitySize"            "readDataEntitySizes"          
#> [33] "readDataPackage"               "readDataPackageAcl"           
#> [35] "readDataPackageRmd"            "readDataPackageArchive"       
#> [37] "readDataPackageDoi"            "readDataPackageError"         
#> [39] "readDataPackageFromDoi"        "readDataPackageReport"        
#> [41] "readDataPackageReportAcl"      "readDataPackageReportRmd"     
#> [43] "readDataPackageReportChecksum" "readDataPackageReportDoi"     
#> [45] "readEvaluateReport"            "readMetadata"                 
#> [47] "readMetadataDublinCore"        "readMetadataAcl"              
#> [49] "readMetadataRmd"               "readMetadataChecksum"         
#> [51] "readMetadataDoi"               "readMetadataFormat"           
#> [53] "searchDataPackages"            "updateDataPackage"            
#> [55] "createSubscription"            "deleteSubscription"           
#> [57] "executeSubscription"           "getMatchingSubscriptions"     
#> [59] "getSubscriptionWithId"         "notifyOfEvent"                
#> [61] "createJournalCitation"         "deleteJournalCitation"        
#> [63] "getCitationWithId"             "listDataPackageCitations"     
#> [65] "listPrincipalOwnerCitations"  
}
}
\seealso{
Other Listing: 
\code{\link{list_data_descendants}()},
\code{\link{list_data_entities}()},
\code{\link{list_data_package_identifiers}()},
\code{\link{list_data_package_revisions}()},
\code{\link{list_data_package_scopes}()},
\code{\link{list_data_sources}()},
\code{\link{list_deleted_data_packages}()},
\code{\link{list_recent_changes}()},
\code{\link{list_recent_uploads}()},
\code{\link{list_user_data_packages}()}
}
\concept{Listing}
